<?php
/**
 * Archive Template
 * Sportifieds Theme
 */

get_header();
?>

<main id="primary" class="site-main archive-content">

<header class="archive-header">
    <h1 class="archive-title"><?php the_archive_title(); ?></h1>
    <div class="archive-description"><?php the_archive_description(); ?></div>
</header>

<?php if ( have_posts() ) : ?>

    <div class="archive-posts">

    <?php while ( have_posts() ) : the_post(); ?>

        <article id="post-<?php the_ID(); ?>" <?php post_class('archive-item'); ?>>

            <h2 class="archive-post-title">
                <a href="<?php the_permalink(); ?>">
                    <?php the_title(); ?>
                </a>
            </h2>

            <div class="archive-excerpt">
                <?php the_excerpt(); ?>
            </div>

        </article>

    <?php endwhile; ?>

    </div>

<?php else : ?>

    <p>No content found.</p>

<?php endif; ?>

</main>

<?php get_footer(); ?>
